<?php $__env->startSection('content'); ?>

    <div class="sixteen wide tablet sixteen wide computer column ">
        <div class="ui segment">
            
            <h4 class="ui dividing header teal centered">DETALLES DE VENTA</h4>
            
            <div class="ui warning message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Personal que registró la venta :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column"><?php echo e(ucwords(mb_strtolower($data->usuario->nombres))); ?> <?php echo e(ucwords(mb_strtolower($data->usuario->apellidos))); ?> (<?php echo e($data->usuario->username); ?>)</div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile seven wide tablet  five wide computer column message_header">Fecha que se registró la venta :</div>
                        <div class="sixteen wide mobile nine wide tablet  eleven wide computer column"><?php echo e(ucwords(mb_strtolower($data->created_at))); ?></div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet  five wide computer column message_header">Tienda donde se realizó la venta:</div>
                        <div class="sixteen wide mobile eight wide tablet  eleven wide computer column"><?php echo e(ucwords(mb_strtolower($data->local->nombre))); ?> (<?php echo e(ucwords(mb_strtolower($data->local->direccion))); ?>)</div>
                    </div>
                </div>
            </div>    

            <div class="ui success message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet three wide computer column message_header">Nombre de Cliente :</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column"><a href="<?php echo e(url('cliente/editar/'.$data->id_cliente)); ?>" title="Clic para ver informacion"><?php echo e(ucwords(mb_strtolower($data->cliente->nombre))); ?> (<?php echo e($data->cliente->tipo_documento->nombre); ?> : <?php echo e($data->cliente->numero_documento); ?>)</a></div>
                    </div>
                     <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile six wide tablet  three wide computer column message_header">Direccion de Cliente:</div>
                        <div class="sixteen wide mobile ten wide tablet  thirteen wide computer column"><?php echo e(ucwords(mb_strtolower($data->cliente->direccion))); ?></div>
                    </div>
                </div>
            </div>

            <div class="ui info message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Tipo de Comprobante :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column"><?php echo e($data->tipo_comprobante->nombre); ?></div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">N° Comprobante :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column"><?php echo e($data->nombre_comprobante); ?></div>
                    </div>
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Fecha de Venta :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column"><?php echo e($data->fecha_venta); ?></div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Monto Total de la Venta :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">S/ <?php echo e($data->total_venta); ?></div>
                    </div>
                    
                    <?php if($data->id_nota != null): ?>
                        <div class="row" style="padding-bottom: 0px !important">
                            <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Estado de comprobante:</div>
                            <div class="sixteen wide mobile eight wide tablet  twelve wide computer column" style="color: red!important">El comprobante fue ANULADO  <a style="text-decoration: underline;" href="<?php echo e(url('nota/detalles/'.$data->id_nota)); ?>">(ver detalles)</a></div>
                        </div>
                    <?php endif; ?>

                    

                </div>
            </div>
            
            <?php if($data->tipo_pago == 'CREDITO'): ?>
            <div class="ui error message">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0px !important">
                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Tipo de Venta :</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column">AL <?php echo e($data->tipo_pago); ?></div>

                        <div class="sixteen wide mobile eight wide tablet four wide computer column message_header">Fecha a cobrar la deuda:</div>
                        <div class="sixteen wide mobile eight wide tablet four wide computer column"><?php echo e($data->fecha_pago); ?></div>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <div class="ui hidden divider"></div>
            <table class="ui table">
                <thead>
                    <tr>
                        <th class="center aligned">Producto</th>
                        <th class="center aligned" data-tooltip="Unidad de Medida" data-position="top center" data-inverted="">U. Med.</th>
                        <th class="center aligned" data-tooltip="Cantidad vendida" data-position="top center" data-inverted="">Cant.</th>
                        <th class="center aligned" data-tooltip="Precio de venta" data-position="top center" data-inverted="">Precio S/</th>
                        <th class="center aligned" data-tooltip="Monto de Descuento" data-position="top center" data-inverted="">Dscto S/</th>
                        <th class="center aligned">Subtotal</th>
                    </tr>
                </thead>
                <tbody id="tbody">
                    <?php $__currentLoopData = $detalle_venta; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $venta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr data-table="<?php echo e($venta->id_detalle_venta); ?>">
                        <td><a href="<?php echo e(url('producto/editar/'.$venta->id_producto)); ?>" title="Clic para ver informacion"><?php echo e(ucwords(mb_strtolower($venta->producto->nombre))); ?> (<?php echo e($venta->producto->tipo_presentacion->nombre); ?>)</a></td>
                        <td><?php echo e($venta->producto->unidad_medida->nombre); ?></td>
                        <td><?php echo e($venta->cantidad); ?></td>
                        <td><?php echo e($venta->precio_venta); ?></td>
                        <td>-<?php echo e($venta->descuento); ?></td>
                        <td class="warning"><?php echo e($venta->precio_venta_total); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

            <div class="form_footer" >
                <a class="ui small left  floated default button" href="<?php echo e(URL::previous()); ?>"><i class="arrow left icon"></i>REGRESAR</a>
                <?php if($data->estado_envio == 'ACEPTADO' && $data->id_nota == null): ?>
                    <a class="ui small right floated red button btn_anular" href="<?php echo e(url('nota/credito/'.$venta->id_venta)); ?>"><i class="times icon"></i>Anular venta</a>
                <?php endif; ?>
                <div class="ui small right floated primary button btn_imprimir" data-id="<?php echo e($data->id_venta); ?>"><i class="print icon"></i>Imprimir</div>
                <div class="ui small right floated green button btn_enviar"><i class="paper plane icon"></i>Enviar Correo</div>
            </div>  

        </div>
    </div>

    <!--start mail modal -->
    <div class="ui standard tiny modal" id="email_modal">
        <div class="header">Enviar Comprobante</div>
        <div class="content">
            <div class="description">
                <div class="ui equal width grid">
                    <div class="row" style="padding-bottom: 0 !important">
                        <div class="five wide column " style="margin-top: 5px;text-align: right"><b>Email del cliente : </b></div>
                        <div class="eleven wide column"><div class="ui small fluid input ">
                          <input type="text" id="email_cliente" size="20" maxlength="100" value="<?php echo e($data->cliente->email); ?>">
                        </div></div>
                    </div> 
                </div>
            </div>
        </div>   
        <div class="actions" >
            <div class="ui left floated black right labeled icon deny button" style="margin-bottom: 1em">Cerrar<i class="times icon"></i></div>
            <div class="ui right floated primary button btn_enviar_correo"  data-id="<?php echo e($data->id_venta); ?>"><i class="paper plane icon"></i>ENVIAR</div>
        </div>
    </div>
    <!--end mail modal -->


 
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('js/venta/detalles.js')); ?>"></script>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layout.main', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>