@extends('layout.main')
@section('content')
    
    @if ($data)
        <div class="sixteen wide tablet fifteen wide computer column ">
            <div class="ui segment">
                
                <h4 class="ui dividing header teal centered">EDITAR DATOS DE CLIENTE</h4>
                <br>

                <form class="ui form" id="frmEditar" autocomplete="off">
                    <input type="hidden" id="id_cliente" name="id_cliente" value="{{ $data->id_cliente }}">
                    
                    <div class="field">
                        <div class="field">
                            <label>Nombre o Razon Social</label>
                            <div class="ui small input ">
                              <input type="text" name="nombre" maxlength="200" oninput="$.upperCase(this)" value="{{ $data->nombre }}">
                            </div>
                        </div>
                    </div>
                    
                    <div class="two fields">
                        <div class="field">
                            <label>Tipo de Documento</label>
                            <select class="ui small input dropdown" name="id_tipo_documento">
                                @foreach($tipo_documento as $tipo)
                                    <option value=""> Seleccione</option>
                                    @if($tipo->id_tipo_documento== $data->id_tipo_documento)
                                        <option value="{{ $tipo->id_tipo_documento }}" selected>{{ $tipo->nombre }}</option>
                                    @else
                                        <option value="{{ $tipo->id_tipo_documento }}">{{ $tipo->nombre }}</option>
                                    @endif
                                @endforeach
                            </select>  
                        </div>
                        <div class="field">
                            <label>Numero de Documento</label>
                            <div class="ui small input ">
                              <input type="text" name="numero_documento" maxlength="11" value="{{ $data->numero_documento }}">
                            </div>
                        </div>
                    </div> 

                    <div class="two fields">
                        <div class="field">
                            <label>Direccion</label>
                            <div class="ui small input ">
                              <input type="text" name="direccion" maxlength="100" oninput="$.upperCase(this)" value="{{ $data->direccion }}">
                            </div>
                        </div>
                        <div class="field">
                            <label>Telefono</label>
                            <div class="ui small input ">
                              <input type="text" name="telefono"  maxlength="15" value="{{ $data->telefono }}">
                            </div>
                        </div>
                    </div>

                    <div class="two fields">
                        <div class="field">
                            <label>Email</label>
                            <div class="ui small input ">
                              <input type="text" name="email" maxlength="100" value="{{ $data->email }}">
                            </div>
                        </div>

                        @if($empresa->modulo_puntos==1)
                        <div class="field">
                            <label>Puntos Acumulados</label>
                            <div class="ui small input ">
                              <input type="text" name="email" maxlength="100" value="{{ $data->puntos }}" readonly>
                            </div>
                        </div>
                        @endif
                    </div>
                        
                    <div class="form_footer">
                        <a class="ui left floated default button" href="{{ URL::previous() }}"><i class="arrow left icon"></i>REGRESAR</a>

                        <div class="ui right floated primary button btn_guardar"><i class="save icon"></i>GUARDAR CAMBIOS</div>
                        @if($empresa->modulo_puntos==1)
                        <div class="ui right floated orange button btn_canjear"><i class="refresh icon"></i>CANJEAR PUNTOS</div>
                        @endif
                    </div>    
                </form>

            </div>
        </div>
        <!--start update modal -->
        <div class="ui small basic modal" id="update_modal">
            <div class="ui icon header"><i class="paper plane icon"></i>Guardar cambios</div>
            <div class="content" style="text-align: center; font-size: 16px">
              <p>¿Está seguro que quiere guardar los cambios que hizo?</p>
            </div>
            <div class="actions">
                <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
                <div class="ui green ok inverted button" title="Haga clic para guardar cambios"> <i class="checkmark icon"></i>Guardar</div>
            </div>
        </div>
        <!--end update modal -->

        <!--start canjear modal -->
        <div class="ui small basic modal" id="canjear_modal">
            <div class="ui icon header"><i class="dollar icon"></i>Canjear Puntos del Cliente</div>
            <div class="content" style="text-align: center; font-size: 16px">
              <p>Se canjearan los puntos del cliente, los puntos acumulados volveran a cero</p>
              <p>¿Desea proceder?</p>
            </div>
            <div class="actions">
                <div class="ui red basic cancel inverted button" title="Haga clic para salir"><i class="remove icon"></i>Cancelar</div>
                <div class="ui green ok inverted button" title="Haga clic para guardar cambios"> <i class="checkmark icon"></i>Canjear ahora</div>
            </div>
        </div>
        <!--end canjear modal -->
    @else
        <div class="sixteen wide tablet fifteen wide computer column ">
            <div class="ui segment">
                <h3 class="ui header black centered">No se encuentra el registro que desea editar</h3>
            </div>
        </div>    
    @endif

@stop

@section('scripts')
    <script src="{{ asset('js/cliente/editar.js') }}"></script>
@stop


