<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class DetalleCompra extends Model
{
    protected $table = 'detalle_compra';
    protected $primaryKey = 'id_detalle_compra';

    protected $fillable = [
        'id_detalle_compra', 'id_compra','id_producto', 'cantidad', 'precio_compra_unitario', 'precio_compra_total', 'precio_venta_unitario', 'utilidad','estado'
    ];

    public function compra()
    {
        return $this->belongsTo('App\Models\Compra', 'id_compra');
    }
    public function producto()
    {
        return $this->belongsTo('App\Models\Producto', 'id_producto');
    }
}
