<?php

namespace App\Http\Controllers;

use Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use App\Models\Rol;
use App\Models\Local;
use App\Models\Usuario;

class UsuarioController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:usuario');
    }

    public function nuevo()
    {
	 	return view('usuario.nuevo', [ 'roles' => Rol::where('estado', 1)->get(), 'locales' => Local::where('estado', 1)->get() ]); 
	}

	public function listar()
    {
	 	$res = Usuario::with(['rol', 'local'])->where('estado', 1)->paginate(10);
        return view('usuario.listar', [ 'data' => $res]); 
	}

    public function existeCampo(Request $request)
    {
        if ($request->ajax())
        {    
            $val = 0;
            if ($request->valor != '') {
                $val = Usuario::where($request->campo, '=', $request->valor)->count();
            }
            
            return response()->json($val); 
        }
    }
    public function existeCampoEditar(Request $request)
    {
        if ($request->ajax())
        {    
            $val = 0;
            if ($request->valor != '') {
                $val = Usuario::where($request->campo, '=', $request->valor)->where('id_usuario', '<>', $request->id_usuario)->count();
            }
            
            return response()->json($val); 
        }
    }

	public function registrar(Request $request)
    {
        if ($request->ajax())
        {    
            $fileName = 'img/avatar/default.png';
           
            if ($request->genero == "Masculino") 
            {
                $fileName = 'img/avatar/male_'.rand(1,3).'.png';
            }
            if ($request->genero == "Femenino") 
            {
                $fileName = 'img/avatar/female_'.rand(1,3).'.png';
            }
            $request->request->add(['url_avatar' => $fileName]); 
            $request['password'] = Hash::make($request->password);
            
            $res = Usuario::create($request->all());

            return response()->json($res ? ['message' => 'success'] : ['message' => 'error']); 
        }
	}

    public function editar($id)
    {
        return view('usuario.editar', [
            'data' => Usuario::where(['id_usuario' => $id , 'estado' => 1])->first(), 
            'roles' => Rol::all(), 
            'locales' => Local::all() 
        ]); 
    }

    public function actualizar(Request $request)
    {
        if ($request->ajax())
        {
            $data = Usuario::find($request->id_usuario);

            $data->nombres            = $request->nombres; 
            $data->apellidos          = $request->apellidos;
            $data->username           = $request->username;
            $data->dni                = $request->dni;
            $data->fecha_nacimiento   = $request->fecha_nacimiento;
            $data->domicilio          = $request->domicilio;
            $data->telefono           = $request->telefono;
            $data->email              = $request->email;
            $data->id_rol             = $request->id_rol;
            $data->id_local           = $request->id_local;

            $res  = $data->save();

            return response()->json($res ? ['message' => 'success'] : ['message' => 'error']);  
        }
    }

    public function eliminar(Request $request)
    {
        if ($request->ajax())
        {
            $data = Usuario::find($request->id_usuario);
            $data->estado = 0;
            $res  = $data->save();

            return response()->json($res ? ['message' => 'success'] : ['message' => 'error']);
        }      
    }

    public function getById(Request $request)
    {
        if ($request->ajax())
        {
            $res = Usuario::with(['rol', 'local'])->find($request->id_usuario);
            return response()->json($res);  
        }
    }

    public function perfil($username)
    {
        return view('usuario.perfil', [
            'data' => Usuario::with(['rol', 'local'])->where(['username' => $username , 'estado' => 1])->first(), 
            'roles' => Rol::all(), 
            'locales' => Local::all() 
        ]); 
    }

    public function actualizarPassword(Request $request)
    {
        if ($request->ajax())
        {
            $data = Usuario::find($request->id_usuario);

            $data->password = bcrypt($request->password);

            $res  = $data->save();

            return response()->json($res ? ['message' => 'success'] : ['message' => 'error']);  
        }
    }


}
