<?php

namespace App\Http\Controllers\Auth;

use Auth;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Cache;
use App\Models\Local;
use App\Models\Usuario;

class LoginController extends Controller
{
    public function __construct()
    {
        $this->middleware('guest:usuario')->except('logout');
    }

    public function showLoginForm()
    {
        $res = Local::with('tipo_local')->where('estado', 1)->get();
        return view('login.index', [ 'data' => $res]); 
        //return view('login.index');
    }

    public function login(Request $request)
    {
        $validation = array('username' => 'required', 'password' => 'required', 'id_local' => 'required');
        $messages = array(
            'username.required' => 'Ingrese usuario',
            'password.required' => 'Ingrese contraseña',
            'id_local.required' => 'Seleccione una sucursal'
        );

        $validator = Validator::make($request->all(), $validation, $messages);

        if ($validator->fails()) 
        {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $credentials = array(
            'username' => $request->username,
            'password' => $request->password,
            'estado' => 1
        );

        if (Auth::guard('usuario')->attempt($credentials, false)) 
        {
            $data = Usuario::find(Auth::guard("usuario")->user()->id_usuario);
            $data->id_local = $request->id_local; 
            $data->save();
            
            return redirect()->route('home');
        } 
        
        return redirect()->back()->with('flash_error', 'Los datos de acceso son incorrectos');
    }

    public function logout(Request $request)
    {
        Auth::logout();
        Cache::flush();
        Auth::guard('usuario')->logout();
        $request->session()->forget('key');
        $request->session()->flush();
        $request->session()->regenerate();

        return back();
    }
}
